<?php
require_once 'includes/config.php';
require_once 'functions_live.php';

// Test different slug formats
$test_slugs = [
    "2025/08/16/chicago-restaurant-fails-inspection-putting-diners-at-risk",
    "/2025/08/16/chicago-restaurant-fails-inspection-putting-diners-at-risk"
];

echo "<h2>Testing Article Retrieval</h2>";

// First, get all articles to see what slugs exist
$all_query = '{
    Get {
        Articles(limit: 10) {
            title
            slug
        }
    }
}';

echo "<h3>All Articles in Database:</h3>";
$all_response = queryWeaviate($all_query);
if ($all_response && isset($all_response['data']['Get']['Articles'])) {
    foreach ($all_response['data']['Get']['Articles'] as $article) {
        echo "Title: " . $article['title'] . "<br>";
        echo "Slug: <code>" . $article['slug'] . "</code><br><br>";
    }
}

echo "<h3>Testing Slug Queries:</h3>";
foreach ($test_slugs as $slug) {
    echo "<h4>Testing slug: <code>$slug</code></h4>";
    
    // Try the GraphQL query
    $query = '{
        Get {
            Articles(where: {path: ["slug"], operator: Equal, valueText: "' . addslashes($slug) . '"}) {
                title
                slug
            }
        }
    }';
    
    $response = queryWeaviate($query);
    if ($response && isset($response['data']['Get']['Articles'][0])) {
        echo "✅ Found: " . $response['data']['Get']['Articles'][0]['title'] . "<br>";
    } else {
        echo "❌ Not found<br>";
    }
}
?>