<?php
// Test what path we're getting
$path = trim($_SERVER['REQUEST_URI'], '/');
$path = parse_url($path, PHP_URL_PATH);

// Strip the _sites/cleankitchens prefix if present  
if (strpos($path, '_sites/cleankitchens/') === 0) {
    $path = substr($path, strlen('_sites/cleankitchens/'));
}

echo "REQUEST_URI: " . $_SERVER['REQUEST_URI'] . "\n";
echo "Parsed path: " . $path . "\n";

// Test if it matches date pattern
if (preg_match('/^\d{4}\/\d{2}\/\d{2}\//', $path)) {
    echo "✓ Matches date pattern\n";
    echo "Full slug to search: " . $path . "\n";
} else {
    echo "✗ Does not match date pattern\n";
}
?>