<?php
require_once 'includes/config.php';
require_once 'functions_live.php';

echo "<h2>Testing Weaviate Query</h2>";

// Test the exact query
$query = '{
    Get {
        Articles(limit: 3, sort: [{path: ["published_date"], order: desc}]) {
            title
            slug
            excerpt
            city
            state
            published_date
            image_url
            establishment_name
        }
    }
}';

echo "<h3>Query:</h3>";
echo "<pre>" . htmlspecialchars($query) . "</pre>";

// Execute via queryWeaviate function
$response = queryWeaviate($query);

echo "<h3>Response:</h3>";
echo "<pre>";
var_dump($response);
echo "</pre>";

// Check what we got
if ($response && isset($response['data']['Get']['Articles'])) {
    echo "<h3>✅ Articles Found:</h3>";
    foreach ($response['data']['Get']['Articles'] as $article) {
        echo "- " . $article['title'] . "<br>";
    }
} else {
    echo "<h3>❌ No Articles Found</h3>";
}
?>