<?php
require_once 'includes/cache.php';

echo "Testing Redis Cache...\n\n";

// Test connection
echo "1. Connection: " . ($cache->isConnected() ? "✓ Connected" : "✗ Failed") . "\n";

// Test set/get
$testData = ['test' => 'data', 'timestamp' => time()];
$cache->set('test:key', $testData, 60);
$retrieved = $cache->get('test:key');

echo "2. Set/Get: " . ($retrieved && $retrieved['test'] === 'data' ? "✓ Working" : "✗ Failed") . "\n";

// Test delete
$cache->delete('test:key');
$deleted = $cache->get('test:key');
echo "3. Delete: " . ($deleted === null ? "✓ Working" : "✗ Failed") . "\n";

// Check current cache size
$redis = new Redis();
$redis->connect('127.0.0.1', 6379);
$redis->select(1);
$keys = $redis->keys('cleankitchens:*');
echo "\n4. Current cached items: " . count($keys) . "\n";

if (count($keys) > 0) {
    echo "   Sample keys:\n";
    foreach (array_slice($keys, 0, 5) as $key) {
        echo "   - " . $key . "\n";
    }
}

echo "\nCache test complete!\n";