<!-- Pattern Story Template -->
<div class="container">
    <article class="article-wrapper">
        <header class="article-header">
            <div class="article-meta">
                <span><?= $patternData['location'] ?></span>
                <span>•</span>
                <span><?= date('F j, Y', strtotime($patternData['published_date'])) ?></span>
                <span>•</span>
                <span><?= $patternData['read_time'] ?> min read</span>
                <span>•</span>
                <span class="pattern-badge" style="background: var(--accent-color); color: white; padding: 2px 8px; border-radius: 10px; font-size: 0.75rem; font-weight: 600;">INVESTIGATION</span>
            </div>
            <h1 class="article-title"><?= htmlspecialchars($patternData['title']) ?></h1>
            <p class="article-subtitle" style="font-size: 1.25rem; color: var(--text-secondary); margin: 1rem 0 0; line-height: 1.4;"><?= htmlspecialchars($patternData['subtitle']) ?></p>
        </header>

        <div class="article-image">
            <picture>
                <source srcset="<?= getOptimizedImageUrl('', 'page', $patternData) ?>" type="image/webp">
                <img src="<?= getOptimizedImageUrl('', 'og', $patternData) ?>" 
                     alt="<?= htmlspecialchars($patternData['image_alt']) ?>" 
                     width="1200" 
                     height="630"
                     class="image-loading"
                     onload="this.classList.remove('image-loading')">
            </picture>
        </div>

        <!-- Pattern Summary Stats -->
        <div class="pattern-summary" style="background: #f8f9fa; border: 1px solid #e9ecef; border-radius: 8px; padding: 1.5rem; margin: 2rem 0;">
            <h2 style="margin-top: 0; font-size: 1.25rem; color: var(--text-primary);">Investigation Summary</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; margin-top: 1rem;">
                <div>
                    <strong>Pattern Type:</strong> <?= htmlspecialchars($patternData['pattern_type']) ?>
                </div>
                <div>
                    <strong>Articles Analyzed:</strong> <?= number_format($patternData['article_count']) ?>
                </div>
                <div>
                    <strong>Time Period:</strong> <?= $patternData['date_range'] ?>
                </div>
                <div>
                    <strong>Significance:</strong> <?= $patternData['significance_level'] ?>
                </div>
            </div>
        </div>

        <div class="article-content">
            <?= $patternData['content'] ?>
        </div>

        <!-- Related Articles Section -->
        <div class="pattern-articles" style="background: var(--bg-card); border: 1px solid var(--border-color); border-radius: 8px; padding: 1.5rem; margin: 2rem 0;">
            <h2 style="margin-top: 0;">Articles in This Investigation</h2>
            <div class="related-articles-grid" style="display: grid; gap: 1rem; margin-top: 1rem;">
                <?php foreach ($relatedArticles as $article): ?>
                <div class="related-article-item" style="display: flex; align-items: center; padding: 1rem; background: var(--bg-primary); border-radius: 6px; border: 1px solid var(--border-color);">
                    <?php if (!empty($article['image_url'])): ?>
                    <div class="related-image" style="width: 80px; height: 60px; overflow: hidden; border-radius: 4px; margin-right: 1rem; flex-shrink: 0;">
                        <img src="<?= getOptimizedImageUrl('', 'thumb', $article) ?>" 
                             alt="<?= htmlspecialchars($article['establishment_name']) ?>"
                             loading="lazy"
                             style="width: 100%; height: 100%; object-fit: cover;">
                    </div>
                    <?php endif; ?>
                    <div class="related-content" style="flex: 1;">
                        <h3 style="margin: 0 0 0.5rem; font-size: 1rem; line-height: 1.3;">
                            <a href="/<?= htmlspecialchars($article['slug']) ?>" style="text-decoration: none; color: var(--text-primary);"><?= htmlspecialchars($article['title']) ?></a>
                        </h3>
                        <div style="font-size: 0.875rem; color: var(--text-muted);">
                            <?= htmlspecialchars($article['city']) ?>, <?= htmlspecialchars($article['state']) ?> • <?= htmlspecialchars($article['formatted_time']) ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Pattern Methodology -->
        <div class="pattern-methodology" style="background: #fff3cd; border: 1px solid #ffc107; border-radius: 4px; padding: 1rem; margin: 1.5rem 0; font-size: 0.875rem; line-height: 1.5; color: #856404;">
            <strong>Methodology:</strong> This investigation was generated automatically by analyzing patterns in health inspection data. 
            Our system identified <?= $patternData['article_count'] ?> related articles showing similar violations or trends. 
            All data comes from official health department records. 
            <a href="/methodology" style="color: #856404; text-decoration: underline;">Learn more about our methodology</a>.
        </div>

        <div class="article-tags">
            <?php foreach ($patternData['tags'] as $tag): ?>
                <a href="/tag/<?= strtolower(str_replace(' ', '-', $tag)) ?>" class="tag"><?= $tag ?></a>
            <?php endforeach; ?>
        </div>

        <!-- Share Section -->
        <aside class="share-section" id="shareSection">
            <div class="share-title">Share This Investigation</div>
            <div class="share-buttons">
                <a href="#" class="share-btn share-facebook" onclick="shareOnFacebook(event)" aria-label="Share on Facebook">
                    <span class="share-icon">F</span>
                    <span class="share-text">Facebook</span>
                </a>
                <a href="#" class="share-btn share-twitter" onclick="shareOnTwitter(event)" aria-label="Share on X">
                    <span class="share-icon">𝕏</span>
                    <span class="share-text">X</span>
                </a>
                <a href="#" class="share-btn share-email" onclick="shareViaEmail(event)" aria-label="Share via Email">
                    <span class="share-icon">✉</span>
                    <span class="share-text">Email</span>
                </a>
            </div>
        </aside>
    </article>
</div>

<!-- Related Patterns -->
<section class="container related-section">
    <h2 class="section-title">Related Investigations</h2>
    <div class="row">
        <?php foreach ($relatedPatterns as $pattern): ?>
        <div class="col col-md-4">
            <div class="related-card">
                <h3><a href="/<?= $pattern['slug'] ?>"><?= htmlspecialchars($pattern['title']) ?></a></h3>
                <p class="related-meta"><?= $pattern['location'] ?> • <?= $pattern['article_count'] ?> articles • <?= timeAgo($pattern['published_date']) ?></p>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</section>

<style>
/* Pattern story specific styles */
.pattern-badge {
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.article-subtitle {
    font-style: italic;
}

.pattern-summary {
    border-left: 4px solid var(--accent-color);
}

.related-article-item:hover {
    background: var(--bg-secondary);
}

.pattern-methodology {
    border-left: 4px solid #ffc107;
}

@media (max-width: 768px) {
    .related-article-item {
        flex-direction: column;
        text-align: center;
    }
    
    .related-image {
        margin-right: 0 !important;
        margin-bottom: 1rem;
        width: 100px;
        height: 75px;
    }
    
    .pattern-summary > div {
        grid-template-columns: 1fr;
    }
}
</style>