<div class="container">
    <h1><?= htmlspecialchars($pageData['h1']) ?></h1>
    
    <?php if ($newsData['format'] === 'cards'): ?>
    <!-- Rich Card Format (Pages 1-10) -->
    <div class="news-grid">
        <?php foreach ($newsData['articles'] as $article): ?>
        <article class="news-card">
            <a href="/<?= htmlspecialchars($article['slug']) ?>" class="news-card-link">
                <?php if (!empty($article['image_url'])): ?>
                <div class="news-card-image">
                    <img src="<?= getOptimizedImageUrl('', 'thumb', $article) ?>" 
                         alt="<?= htmlspecialchars($article['establishment_name'] ?? 'Restaurant inspection') ?>"
                         loading="lazy"
                         width="400"
                         height="300">
                </div>
                <?php endif; ?>
                <div class="news-card-content">
                    <h2 class="news-card-title"><?= htmlspecialchars($article['title']) ?></h2>
                    <?php if (!empty($article['excerpt'])): ?>
                    <p class="news-card-excerpt"><?= htmlspecialchars(substr($article['excerpt'], 0, 150)) ?>...</p>
                    <?php endif; ?>
                    <div class="news-card-meta">
                        <span class="location"><?= htmlspecialchars($article['city']) ?>, <?= htmlspecialchars($article['state']) ?></span>
                        <span class="separator">•</span>
                        <time datetime="<?= htmlspecialchars($article['published_date']) ?>">
                            <?= htmlspecialchars($article['formatted_date']) ?>
                        </time>
                        <span class="separator">•</span>
                        <span class="time-ago"><?= htmlspecialchars($article['formatted_time']) ?></span>
                    </div>
                </div>
            </a>
        </article>
        <?php endforeach; ?>
    </div>
    
    <?php else: ?>
    <!-- Compact List Format (Pages 11+) -->
    <div class="news-list">
        <?php foreach ($newsData['articles'] as $article): ?>
        <article class="news-list-item">
            <h2 class="news-list-title">
                <a href="/<?= htmlspecialchars($article['slug']) ?>">
                    <?= htmlspecialchars($article['title']) ?>
                </a>
            </h2>
            <div class="news-list-meta">
                <span class="location"><?= htmlspecialchars($article['city']) ?>, <?= htmlspecialchars($article['state']) ?></span>
                <span class="separator">•</span>
                <time datetime="<?= htmlspecialchars($article['published_date']) ?>">
                    <?= htmlspecialchars($article['formatted_date']) ?>
                </time>
            </div>
        </article>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
    
    <!-- Pagination -->
    <nav class="pagination" aria-label="News pagination">
        <?php if ($newsData['page'] > 1): ?>
        <a href="/news<?= $newsData['page'] === 2 ? '' : '/page/' . ($newsData['page'] - 1) ?>" 
           class="pagination-prev" rel="prev">← Previous</a>
        <?php endif; ?>
        
        <span class="pagination-current">Page <?= $newsData['page'] ?></span>
        
        <?php if ($newsData['has_next']): ?>
        <a href="/news/page/<?= $newsData['page'] + 1 ?>" 
           class="pagination-next" rel="next">Next →</a>
        <?php endif; ?>
    </nav>
</div>

<style>
/* News Grid (Cards) */
.news-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 2rem;
    margin: 2rem 0;
}

.news-card {
    background: var(--bg-card);
    border-radius: 8px;
    overflow: hidden;
    box-shadow: var(--shadow-sm);
    transition: transform 0.2s, box-shadow 0.2s;
}

.news-card:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.news-card-link {
    display: block;
    text-decoration: none;
    color: inherit;
}

.news-card-image {
    width: 100%;
    height: 200px;
    overflow: hidden;
    background: var(--bg-secondary);
}

.news-card-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.news-card-content {
    padding: 1.25rem;
}

.news-card-title {
    font-size: 1.25rem;
    font-weight: 600;
    line-height: 1.3;
    margin-bottom: 0.75rem;
    color: var(--text-primary);
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.news-card-excerpt {
    font-size: 0.9375rem;
    line-height: 1.5;
    color: var(--text-secondary);
    margin-bottom: 1rem;
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.news-card-meta {
    font-size: 0.8125rem;
    color: var(--text-muted);
    display: flex;
    align-items: center;
    flex-wrap: wrap;
    gap: 0.25rem;
}

/* News List (Compact) */
.news-list {
    margin: 2rem 0;
}

.news-list-item {
    padding: 1.25rem 0;
    border-bottom: 1px solid var(--border-color);
}

.news-list-item:first-child {
    padding-top: 0;
}

.news-list-title {
    font-size: 1.125rem;
    font-weight: 500;
    margin-bottom: 0.5rem;
}

.news-list-title a {
    color: var(--text-primary);
    text-decoration: none;
    transition: color 0.2s;
}

.news-list-title a:hover {
    color: var(--accent-color);
}

.news-list-meta {
    font-size: 0.875rem;
    color: var(--text-muted);
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.separator {
    margin: 0 0.25rem;
}

/* Pagination */
.pagination {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 2rem;
    margin: 3rem 0;
    padding: 1rem 0;
    border-top: 1px solid var(--border-color);
}

.pagination-prev,
.pagination-next {
    padding: 0.5rem 1rem;
    background: var(--bg-secondary);
    color: var(--text-primary);
    text-decoration: none;
    border-radius: 4px;
    transition: background 0.2s;
}

.pagination-prev:hover,
.pagination-next:hover {
    background: var(--accent-color);
    color: white;
}

.pagination-current {
    font-weight: 500;
    color: var(--text-secondary);
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .news-grid {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .news-card-meta {
        font-size: 0.75rem;
    }
    
    .pagination {
        gap: 1rem;
    }
}

@media (min-width: 769px) and (max-width: 1024px) {
    .news-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}
</style>