<!-- Article Content -->
<div class="container">
    <article class="article-wrapper">
        <header class="article-header">
            <div class="article-meta">
                <span><?= $article['city'] ?>, <?= $article['state'] ?></span>
                <span>•</span>
                <span><?= date('F j, Y', strtotime($article['published_date'])) ?></span>
                <span>•</span>
                <span>2 min read</span>
            </div>
            <h1 class="article-title"><?= htmlspecialchars($article['title']) ?></h1>
        </header>

        <div class="article-image">
            <img src="/assets/images/health-inspection-report_page.webp" 
                 alt="<?= htmlspecialchars($article['establishment_name']) ?> health inspection report" 
                 width="800" 
                 height="457"
                 fetchpriority="high">
        </div>

        <div class="article-content">
            <?= $article['content'] ?>
        </div>

        <div class="article-tags">
            <?php foreach ($article['tags'] as $tag): ?>
                <a href="/tag/<?= strtolower(str_replace(' ', '-', $tag)) ?>" class="tag"><?= $tag ?></a>
            <?php endforeach; ?>
        </div>

        <!-- Share Section (End of article on mobile, floating on desktop) -->
        <aside class="share-section" id="shareSection">
            <div class="share-title">Share This Story</div>
            <div class="share-buttons">
                <a href="#" class="share-btn share-facebook" onclick="shareOnFacebook(event)" aria-label="Share on Facebook">
                    <span class="share-icon">F</span>
                    <span class="share-text">Facebook</span>
                </a>
                <a href="#" class="share-btn share-twitter" onclick="shareOnTwitter(event)" aria-label="Share on X">
                    <span class="share-icon">𝕏</span>
                    <span class="share-text">X</span>
                </a>
                <a href="#" class="share-btn share-email" onclick="shareViaEmail(event)" aria-label="Share via Email">
                    <span class="share-icon">✉</span>
                    <span class="share-text">Email</span>
                </a>
            </div>
        </aside>
    </article>
</div>

<!-- Related Articles -->
<section class="container related-section">
    <h2 class="section-title">Related Stories</h2>
    <div class="row">
        <?php foreach ($relatedArticles as $related): ?>
        <div class="col col-md-4">
            <div class="related-card">
                <h3><a href="/<?= $related['slug'] ?>"><?= htmlspecialchars($related['title']) ?></a></h3>
                <p class="related-meta"><?= $related['city'] ?>, <?= $related['state'] ?> • <?= timeAgo($related['published_date']) ?></p>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</section>