<div class="container">
    <div class="static-content">
        <?php if ($staticPage === 'contact'): ?>
            <h1><?= $pageData['h1'] ?></h1>
            
            <p>Get in touch with the CleanKitchens editorial team for corrections, story suggestions, or general inquiries.</p>
            
            <h2>Report an Error</h2>
            <p>If you notice an error in our reporting, please email us at <a href="mailto:corrections@cleankitchens.com">corrections@cleankitchens.com</a> with:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Link to the article</li>
                <li>Description of the error</li>
                <li>Supporting documentation if available</li>
            </ul>
            
            <h2>Suggest a Story</h2>
            <p>Have a tip about restaurant health violations? Send it to <a href="mailto:tips@cleankitchens.com">tips@cleankitchens.com</a></p>
            <p>We protect our sources and appreciate community input on food safety issues.</p>
            
            <h2>Press Inquiries</h2>
            <p>Members of the media can contact us at <a href="mailto:press@cleankitchens.com">press@cleankitchens.com</a></p>
            
            <h2>General Inquiries</h2>
            <p>For all other questions, contact us at <a href="mailto:info@cleankitchens.com">info@cleankitchens.com</a></p>
            
            <h2>Mailing Address</h2>
            <p>
                CleanKitchens<br>
                [Address Line 1]<br>
                [City, State ZIP]
            </p>
            
        <?php elseif ($staticPage === 'about'): ?>
            <h1><?= $pageData['h1'] ?></h1>
            
            <p>CleanKitchens is a real-time restaurant health inspection news platform providing transparent, accurate reporting on food safety violations and restaurant closures across major US cities.</p>
            
            <h2>Our Mission</h2>
            <p>We believe the public has a right to know about food safety issues in their communities. By transforming complex government inspection data into clear, accessible news stories, we help diners make informed decisions.</p>
            
            <h2>What We Do</h2>
            <p>Every day, we:</p>
            <ul style="margin-bottom: 24px; padding-left: 24px;">
                <li>Monitor official health department inspection data</li>
                <li>Identify significant violations and closures</li>
                <li>Verify information from government sources</li>
                <li>Publish timely, accurate news stories</li>
                <li>Track patterns across restaurant chains and locations</li>
            </ul>
            
            <h2>Our Data Sources</h2>
            <p>All information comes directly from official city and county health departments. We do not rely on user submissions or unverified sources. Our automated systems check for new inspection data multiple times daily.</p>
            
            <h2>Editorial Independence</h2>
            <p>CleanKitchens maintains complete editorial independence. We do not accept payment from restaurants for coverage decisions. Our only revenue comes from display advertising clearly marked on the site.</p>
            
            <h2>Corrections Policy</h2>
            <p>We take accuracy seriously. If you spot an error, please <a href="/contact">contact us</a> immediately. Corrections are posted promptly and transparently.</p>
            
        <?php elseif ($staticPage === 'search'): ?>
            <h1>Search</h1>
            
            <p>Search functionality coming soon. Use the navigation menu to browse by topics or view the latest articles.</p>
            
            <div style="margin-top: 32px;">
                <h2>Popular Topics</h2>
                <div style="margin-top: 16px;">
                    <a href="/tag/chicago" class="tag">Chicago</a>
                    <a href="/tag/closure" class="tag">Closures</a>
                    <a href="/tag/rodent-activity" class="tag">Rodent Activity</a>
                    <a href="/tag/temperature-violation" class="tag">Temperature Violations</a>
                </div>
            </div>
            
        <?php endif; ?>
    </div>
</div>