<?php

/**

 * States Directory Configuration

 * 

 * This file contains configuration and metadata for the states directory pages.

 */



// Determine if we're on a state-specific page or the main states directory

if (isset($state_code) && !empty($state_info)) {

    // INDIVIDUAL STATE PAGE META

    $page_title = htmlspecialchars($state_info['state_name']) . " Recovery Resources | SoberList.org";

    $meta_description = "Browse our directory of " . number_format($total_state_facilities) . " recovery resources in " . 

                       htmlspecialchars($state_info['state_name']) . ". Find addiction treatment centers, sober living homes, and mental health facilities near you.";

    

    // Add city-specific information if filtering by city

    if (!empty($selected_city)) {

        $page_title = htmlspecialchars($selected_city) . ", " . htmlspecialchars($state_info['state_name']) . " Recovery Resources | SoberList.org";

        $meta_description = "Browse recovery resources in " . htmlspecialchars($selected_city) . ", " . 

                          htmlspecialchars($state_info['state_name']) . ". Find addiction treatment centers, sober living homes, and mental health facilities.";

    }

    

    // Keywords for SEO

    $keywords = "recovery resources, addiction treatment, " . htmlspecialchars($state_info['state_name']) . 

               ", rehabilitation centers, sober living, mental health facilities";

    

    // Set canonical URL (include pagination but not other filters)

    // Using directory-page pagination parameter

    $canonical_url = SITE_URL . "/states/" . strtolower($state_code);

    if ($current_page > 1) {

        $canonical_url .= "?directory-page=" . (int)$current_page;

    }

    

    // Set page-specific flags

    $show_search_form = false;

    $show_featured_resources = false;

    $is_homepage = false;

    $include_directory_css = true;

    

    // Generate schema markup for the state directory

    $schema = [

        "@context" => "https://schema.org",

        "@type" => "CollectionPage",

        "@id" => $canonical_url . "#collectionpage",

        "url" => $canonical_url,

        "name" => $state_info['state_name'] . " Recovery Resources Directory",

        "description" => $meta_description,

        "isPartOf" => [

            "@type" => "WebSite",

            "@id" => SITE_URL . "#website",

            "url" => SITE_URL,

            "name" => "SoberList.org",

            "description" => "Directory of recovery resources nationwide"

        ],

        "about" => [

            "@type" => "Place",

            "name" => $state_info['state_name'],

            "address" => [

                "@type" => "PostalAddress",

                "addressRegion" => $state_info['state_code'],

                "addressCountry" => "US"

            ]

        ]

    ];

    

    // Add items if facilities are present

    if (!empty($facilities)) {

        $itemListElement = [];

        foreach ($facilities as $index => $facility) {

            $facility_url = SITE_URL . "/facility/" . get_facility_slug($facility);

            $itemListElement[] = [

                "@type" => "ListItem",

                "position" => $index + 1,

                "item" => [

                    "@type" => "LocalBusiness",

                    "name" => $facility['name'],

                    "url" => $facility_url,

                    "address" => [

                        "@type" => "PostalAddress",

                        "streetAddress" => $facility['address_line1'],

                        "addressLocality" => $facility['city'],

                        "addressRegion" => $state_info['state_code'],

                        "postalCode" => $facility['zip_code'],

                        "addressCountry" => "US"

                    ]

                ]

            ];

        }

        

        $schema["mainEntity"] = [

            "@type" => "ItemList",

            "itemListElement" => $itemListElement

        ];

    }

    

    // Add pagination info if applicable

    if ($total_pages > 1) {

        if ($current_page > 1) {

            $schema["pagination"] = [

                "previousPage" => SITE_URL . "/states/" . strtolower($state_code) . "?directory-page=" . (int)($current_page - 1)

            ];

        }

        

        if ($current_page < $total_pages) {

            if (!isset($schema["pagination"])) {

                $schema["pagination"] = [];

            }

            $schema["pagination"]["nextPage"] = SITE_URL . "/states/" . strtolower($state_code) . "?directory-page=" . (int)($current_page + 1);

        }

    }

    

} else {

    // MAIN STATES DIRECTORY PAGE META

    $page_title = "Recovery Resources by State | SoberList.org";

    $meta_description = "Browse our nationwide directory of recovery resources organized by state. Find addiction treatment centers, sober living homes, and mental health facilities near you.";

    

    // Keywords for SEO

    $keywords = "recovery resources, addiction treatment, rehabilitation centers, sober living, mental health facilities, state directory";

    

    // Set canonical URL

    $canonical_url = SITE_URL . "/states";

    

    // Set page-specific flags

    $show_search_form = false;

    $show_featured_resources = false;

    $is_homepage = false;

    $include_directory_css = true;

    

    // Generate schema markup for the states directory

    $schema = [

        "@context" => "https://schema.org",

        "@type" => "CollectionPage",

        "@id" => $canonical_url . "#collectionpage",

        "url" => $canonical_url,

        "name" => "Recovery Resources by State",

        "description" => $meta_description,

        "isPartOf" => [

            "@type" => "WebSite",

            "@id" => SITE_URL . "#website",

            "url" => SITE_URL,

            "name" => "SoberList.org",

            "description" => "Directory of recovery resources nationwide"

        ]

    ];

    

    // Add states as ItemList if available

    if (!empty($states)) {

        $itemListElement = [];

        foreach ($states as $index => $state) {

            $state_url = SITE_URL . "/states/" . strtolower($state['state_code']);

            $itemListElement[] = [

                "@type" => "ListItem",

                "position" => $index + 1,

                "item" => [

                    "@type" => "State",

                    "name" => $state['state_name'],

                    "url" => $state_url

                ]

            ];

        }

        

        $schema["mainEntity"] = [

            "@type" => "ItemList",

            "itemListElement" => $itemListElement

        ];

    }

}



// Convert schema to JSON

$schema_json = json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);