#!/usr/bin/env python3
"""
Test the processor with a single inspection to verify fixes
"""

import pandas as pd
from comprehensive_processor import CleanKitchensProcessor

# Create test data with problematic values
test_data = pd.DataFrame([{
    'inspection_id': 'TEST123',
    'inspection_date': pd.Timestamp('2025-08-15'),
    'establishment_name': 'Test Restaurant',
    'address': '123 Test St',
    'city': 'Chicago',
    'state': 'IL',
    'results': 'Fail',
    'violations': float('nan'),  # This is the problem - NaN float
    'violation_count': 5,
    'critical_count': 2
}])

print("Testing processor with NaN violations...")

try:
    processor = CleanKitchensProcessor()
    
    # Test the _safe_str method
    test_value = float('nan')
    safe_value = processor._safe_str(test_value)
    print(f"NaN converted to: '{safe_value}'")
    
    # Test processing
    processor.process_all_inspections(test_data)
    print("✅ Test passed - processor handled NaN values")
    
except AttributeError as e:
    if "'float' object has no attribute" in str(e):
        print(f"❌ Test failed - float attribute error: {e}")
    else:
        print(f"❌ Test failed - other error: {e}")
        
except Exception as e:
    print(f"❌ Test failed with error: {e}")
    
finally:
    if 'processor' in locals():
        processor.weaviate_client.close()