#!/usr/bin/env python3
"""
Check if any facilities have multiple inspections on the same date
"""

import weaviate
import os
from collections import defaultdict
from dotenv import load_dotenv

load_dotenv('/home/chris/.env')

# Connect to Weaviate
client = weaviate.connect_to_local()
articles = client.collections.get("Articles")

print("🔍 Checking for same facility on same date...")

# Get all articles
all_articles = []
batch_size = 100
offset = 0

while True:
    result = articles.query.fetch_objects(limit=batch_size, offset=offset)
    if not result.objects:
        break
    all_articles.extend(result.objects)
    offset += batch_size

print(f"📊 Total articles: {len(all_articles)}")

# Group by facility name + inspection date
facility_date_map = defaultdict(list)
for article in all_articles:
    facility_name = article.properties.get('facility_name', '')
    inspection_date = article.properties.get('inspection_date', '')
    
    if facility_name and inspection_date:
        key = f"{facility_name}|{inspection_date}"
        facility_date_map[key].append(article)

# Check for duplicates
found_duplicates = False
for key, articles_list in facility_date_map.items():
    if len(articles_list) > 1:
        found_duplicates = True
        break

if found_duplicates:
    print("\n✅ YES - Found facilities with multiple inspections on the same date")
else:
    print("\n✅ NO - No facilities have multiple inspections on the same date")

client.close()