#!/bin/bash

# Package the SF Collector for Windows download

echo "Creating Windows package..."

# Create package directory
mkdir -p sf_collector_package

# Copy files
cp SF_Collector_GUI.py sf_collector_package/
cp SF_Collector_Installer.py sf_collector_package/
cp api_receiver.php sf_collector_package/api_receiver_server.php.txt

# Create README
cat > sf_collector_package/README.txt << 'EOF'
SF INSPECTION COLLECTOR v2.0
============================

QUICK START:
-----------
1. Run SF_Collector_Installer.py to install
2. Configure settings.json with your server details
3. Click desktop shortcut to run

FILES INCLUDED:
--------------
- SF_Collector_GUI.py - Main application with GUI
- SF_Collector_Installer.py - Automated installer
- api_receiver_server.php.txt - Server endpoint (upload to your server)

FEATURES:
--------
✓ Professional GUI with status indicators
✓ Real-time progress tracking
✓ Shows download success for each inspection
✓ Shows upload success to server
✓ Activity log with color coding
✓ Statistics dashboard
✓ Settings saved between sessions

REQUIREMENTS:
------------
- Windows 10/11
- Python 3.7+
- Google Chrome
- Internet connection

SUPPORT:
-------
Check the activity log for detailed status information.
All operations show clear success/failure indicators.

EOF

# Create tar archive
tar -czf SF_Collector_Package.tar.gz sf_collector_package/

# Clean up
rm -rf sf_collector_package/

echo "Package created: SF_Collector_Package.tar.gz"
ls -lh SF_Collector_Package.tar.gz