<?php
// Placeholder functions for testing

function getPlaceholderArticles() {
    return getRecentClosures();
}


function getPlaceholderFeaturedArticle() {
    return [
        'title' => 'Popular Downtown Restaurant Chain Temporarily Closed After Critical Violations',
        'excerpt' => 'Health inspectors discovered multiple critical violations including improper food storage temperatures...',
        'city' => 'Chicago',
        'state' => 'IL',
        'published_date' => date('Y-m-d H:i:s', strtotime('-2 hours')),
        'slug' => 'popular-downtown-restaurant-closed',
        'image_url' => 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 800 400\'%3E%3Crect width=\'800\' height=\'400\' fill=\'%23c41e3a\'/%3E%3Ctext x=\'50%25\' y=\'50%25\' font-family=\'sans-serif\' font-size=\'24\' fill=\'white\' text-anchor=\'middle\' dy=\'.3em\'%3EFeatured Article%3C/text%3E%3C/svg%3E'
    ];
}

function getRecentClosures() {
    return [
        [
            'title' => 'Mission District Taqueria Closed for Rodent Infestation',
            'excerpt' => 'Inspectors found evidence of active rodent activity throughout the kitchen area...',
            'city' => 'San Francisco',
            'state' => 'CA',
            'published_date' => date('Y-m-d H:i:s', strtotime('-5 hours')),
            'slug' => 'mission-taqueria-closed',
            'image_url' => 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 400 200\'%3E%3Crect width=\'400\' height=\'200\' fill=\'%23e9ecef\'/%3E%3Ctext x=\'50%25\' y=\'50%25\' font-family=\'sans-serif\' font-size=\'16\' fill=\'%236c757d\' text-anchor=\'middle\' dy=\'.3em\'%3EArticle Image%3C/text%3E%3C/svg%3E'
        ],
        [
            'title' => 'North End Italian Restaurant Shut Down Over Temperature Violations',
            'excerpt' => 'Multiple cold holding violations led to immediate closure of the establishment...',
            'city' => 'Boston',
            'state' => 'MA',
            'published_date' => date('Y-m-d H:i:s', strtotime('-8 hours')),
            'slug' => 'north-end-italian-closed',
            'image_url' => 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 400 200\'%3E%3Crect width=\'400\' height=\'200\' fill=\'%23e9ecef\'/%3E%3Ctext x=\'50%25\' y=\'50%25\' font-family=\'sans-serif\' font-size=\'16\' fill=\'%236c757d\' text-anchor=\'middle\' dy=\'.3em\'%3EArticle Image%3C/text%3E%3C/svg%3E'
        ],
        [
            'title' => 'Beach Restaurant Closed After Sewage Backup',
            'excerpt' => 'Emergency closure ordered after sewage backup affected food preparation areas...',
            'city' => 'Miami',
            'state' => 'FL',
            'published_date' => date('Y-m-d H:i:s', strtotime('-1 day')),
            'slug' => 'beach-restaurant-sewage',
            'image_url' => 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 400 200\'%3E%3Crect width=\'400\' height=\'200\' fill=\'%23e9ecef\'/%3E%3Ctext x=\'50%25\' y=\'50%25\' font-family=\'sans-serif\' font-size=\'16\' fill=\'%236c757d\' text-anchor=\'middle\' dy=\'.3em\'%3EArticle Image%3C/text%3E%3C/svg%3E'
        ]
    ];
}

function getWeeklyArticles() {
    return [
        [
            'title' => 'Manhattan Sees 23% Increase in Violations',
            'excerpt' => 'Analysis reveals concerning trends in temperature control violations...',
            'city' => 'New York',
            'state' => 'NY',
            'meta_label' => 'Weekly Report',
            'slug' => 'manhattan-violations-increase',
            'image_url' => 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 400 200\'%3E%3Crect width=\'400\' height=\'200\' fill=\'%23e9ecef\'/%3E%3C/svg%3E'
        ],
        [
            'title' => 'Fast Food Chain Improves Safety Scores',
            'excerpt' => 'Training program shows results across 200 locations nationwide...',
            'city' => 'National',
            'state' => '',
            'meta_label' => 'Analysis',
            'slug' => 'fast-food-improvements',
            'image_url' => 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 400 200\'%3E%3Crect width=\'400\' height=\'200\' fill=\'%23e9ecef\'/%3E%3C/svg%3E'
        ],
        [
            'title' => 'School Cafeteria Inspections Reveal Issues',
            'excerpt' => 'District audit uncovers need for equipment upgrades...',
            'city' => 'Houston',
            'state' => 'TX',
            'meta_label' => 'Investigation',
            'slug' => 'school-cafeteria-issues',
            'image_url' => 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 400 200\'%3E%3Crect width=\'400\' height=\'200\' fill=\'%23e9ecef\'/%3E%3C/svg%3E'
        ]
    ];
}

function getSampleArticle() {
    return [
        'id' => '12345',
        'title' => 'Popular Downtown Chicago Restaurant Temporarily Closed After Critical Health Violations',
        'slug' => 'portillos-closed-chicago',
        'content' => '<p>The Chicago Department of Public Health ordered the immediate closure of Portillo\'s restaurant at 520 North Clark Street on Monday after inspectors discovered multiple critical food safety violations during a routine inspection.</p>

        <p>According to the inspection report obtained by CleanKitchens, health officials found evidence of <a href="/tag/rodent-activity">rodent activity</a> in food preparation areas, improper cold holding temperatures for several meat products, and inadequate hand washing facilities for employees.</p>

        <p>"The violations posed an imminent health hazard to the public," stated the inspection report. The popular Chicago-style hot dog and Italian beef restaurant must remain closed until all violations are corrected and the establishment passes a follow-up inspection.</p>

        <hr>

        <p>This marks the third closure for a <a href="/tag/portillos">Portillo\'s location</a> in the Chicago area within the past six months. The chain has faced increased scrutiny following a series of food safety issues at multiple locations.</p>

        <p>The restaurant\'s management issued a statement saying they are "working diligently to address all concerns raised by the health department" and hope to reopen within 48 hours. They emphasized their commitment to food safety and promised additional staff training.</p>

        <p>Customers who may have eaten at the location in recent days and experienced illness are encouraged to contact the Chicago Department of Public Health at 312-746-7425.</p>

        <p>This closure comes amid a broader crackdown on <a href="/tag/chicago">restaurant health violations in Chicago</a>, with city inspectors reporting a 23% increase in critical violations found during the first quarter of 2025.</p>',
        
        'meta_title' => 'Popular Downtown Chicago Restaurant Temporarily Closed After Critical Health Violations',
        'meta_description' => 'Health inspectors shut down Portillo\'s on North Clark Street after discovering multiple critical violations including improper food storage and pest activity during routine inspection.',
        'og_title' => 'Portillo\'s on Clark Street Closed for Health Violations',
        'og_description' => 'Chicago health inspectors temporarily closed the popular restaurant after finding critical food safety violations.',
        'city' => 'Chicago',
        'state' => 'IL',
        'published_date' => date('Y-m-d H:i:s'),
        'image_url' => 'data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 630\'%3E%3Crect width=\'1200\' height=\'630\' fill=\'%23c41e3a\'/%3E%3Ctext x=\'50%25\' y=\'50%25\' font-family=\'sans-serif\' font-size=\'32\' fill=\'white\' text-anchor=\'middle\' dy=\'.3em\'%3EAI-Generated Article Image%3C/text%3E%3C/svg%3E',
        'latitude' => 41.8781,
        'longitude' => -87.6298,
        'establishment_name' => 'Portillo\'s',
        'tags' => ['Chicago', 'Portillo\'s', 'Closure', 'Rodent Activity', 'Temperature Violation'],
        'schema_json' => json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'NewsArticle',
            'headline' => 'Popular Downtown Chicago Restaurant Temporarily Closed After Critical Health Violations',
            'description' => 'Health inspectors shut down Portillo\'s on North Clark Street',
            'image' => SITE_URL . '/images/articles/portillos-closed-chicago-2025-01.jpg',
            'datePublished' => date('c'),
            'dateModified' => date('c'),
            'author' => [
                '@type' => 'Organization',
                'name' => 'CleanKitchens Editorial Team'
            ],
            'publisher' => [
                '@type' => 'Organization',
                'name' => 'CleanKitchens',
                'logo' => [
                    '@type' => 'ImageObject',
                    'url' => SITE_URL . '/logo.png'
                ]
            ]
        ])
    ];
}

function getRelatedArticles() {
    return [
        [
            'title' => 'McDonald\'s in Lincoln Park Closed for Similar Violations',
            'slug' => 'mcdonalds-lincoln-park-closure',
            'city' => 'Chicago',
            'state' => 'IL',
            'published_date' => date('Y-m-d H:i:s', strtotime('-3 days'))
        ],
        [
            'title' => 'Portillo\'s Schaumburg Location Reopens After Corrections',
            'slug' => 'portillos-schaumburg-reopens',
            'city' => 'Schaumburg',
            'state' => 'IL',
            'published_date' => date('Y-m-d H:i:s', strtotime('-1 week'))
        ],
        [
            'title' => 'Chicago Increases Restaurant Inspection Frequency',
            'slug' => 'chicago-inspection-increase',
            'city' => 'Chicago',
            'state' => 'IL',
            'published_date' => date('Y-m-d H:i:s', strtotime('-2 weeks'))
        ]
    ];
}

// Helper function for dates
function timeAgo($datetime) {
    $now = new DateTime();
    $then = new DateTime($datetime);
    $diff = $now->diff($then);
    
    if ($diff->days == 0) {
        if ($diff->h == 0) {
            return "Just now";
        } elseif ($diff->h == 1) {
            return "1 hour ago";
        } else {
            return $diff->h . " hours ago";
        }
    } elseif ($diff->days == 1) {
        return "Yesterday";
    } elseif ($diff->days < 7) {
        return $diff->days . " days ago";
    } else {
        return $then->format('M j, Y');
    }
}