<?php
// Direct test without any includes that might interfere
$slug = "2025/08/16/chicago-restaurant-fails-inspection-putting-diners-at-risk";

echo "Testing Weaviate query for slug: $slug\n\n";

$query = '{
    Get {
        Articles(where: {path: ["slug"], operator: Equal, valueText: "' . addslashes($slug) . '"}) {
            title
            slug
        }
    }
}';

echo "Query:\n$query\n\n";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost:8080/v1/graphql');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['query' => $query]));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);
curl_close($ch);

echo "Response:\n";
$data = json_decode($response, true);
print_r($data);

if (isset($data['data']['Get']['Articles'][0])) {
    echo "\n✅ Article found: " . $data['data']['Get']['Articles'][0]['title'];
} else {
    echo "\n❌ Article not found";
}
?>