#!/bin/bash

# Build script to create Windows executable

echo "Building SF Inspection Collector for Windows..."

# Update the SERVER_URL in the Python script with the actual server
sed -i 's|SERVER_URL = "https://cleankitchens.org/data/api_receiver.php"|SERVER_URL = "https://cleankitchens.org/data/api_receiver.php"|g' sf_windows_collector.py

# Build the executable
/home/chris/cleankitchens-env/bin/pyinstaller \
    --onefile \
    --console \
    --name "SF_Inspection_Collector" \
    --distpath ./dist \
    --workpath ./build \
    --specpath ./build \
    sf_windows_collector.py

# Check if build was successful
if [ -f "./dist/SF_Inspection_Collector" ]; then
    echo "✓ Build successful!"
    echo "Executable created at: ./dist/SF_Inspection_Collector"
    
    # Copy to web root for download
    cp ./dist/SF_Inspection_Collector /var/www/twin-digital-media/public_html/_sites/cleankitchens/SF_Inspection_Collector.exe
    echo "✓ Copied to web root for download"
else
    echo "✗ Build failed!"
fi