<?php
require_once 'auth.php';
requireLogin();

// Set current page for navigation
$currentPage = 'dashboard';

// Include necessary files
require_once '../includes/config.php';
require_once 'admin-functions.php';

// Get dashboard statistics
$stats = getDashboardStats();
$serverHealth = getServerHealth();
$recentArticles = getRecentArticles(5);
$popularArticles = getPopularArticles(5);
$pipelineStatus = getPipelineStatus();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - CleanKitchens Admin</title>
    <link rel="stylesheet" href="admin-styles.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <div class="admin-wrapper">
        <?php include 'includes/sidebar.php'; ?>
        
        <div class="admin-content">
            <?php include 'includes/header.php'; ?>
            
            <div class="dashboard">
                <h1>Dashboard</h1>
                
                <!-- Quick Stats -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon">📄</div>
                        <div class="stat-details">
                            <div class="stat-value"><?= number_format($stats['total_articles']) ?></div>
                            <div class="stat-label">Total Articles</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon">👁️</div>
                        <div class="stat-details">
                            <div class="stat-value"><?= number_format($stats['total_views']) ?></div>
                            <div class="stat-label">Total Views</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon">📈</div>
                        <div class="stat-details">
                            <div class="stat-value"><?= number_format($stats['today_views']) ?></div>
                            <div class="stat-label">Today's Views</div>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon">🏷️</div>
                        <div class="stat-details">
                            <div class="stat-value"><?= number_format($stats['total_tags']) ?></div>
                            <div class="stat-label">Total Tags</div>
                        </div>
                    </div>
                </div>
                
                <!-- Server Health -->
                <div class="card">
                    <div class="card-header">
                        <h2>Server Health</h2>
                        <span class="status-badge <?= $serverHealth['status'] ?>"><?= ucfirst($serverHealth['status']) ?></span>
                    </div>
                    <div class="card-body">
                        <div class="health-metrics">
                            <div class="metric">
                                <span class="metric-label">CPU Usage:</span>
                                <div class="progress-bar">
                                    <div class="progress-fill" style="width: <?= $serverHealth['cpu_usage'] ?>%"></div>
                                </div>
                                <span class="metric-value"><?= $serverHealth['cpu_usage'] ?>%</span>
                            </div>
                            
                            <div class="metric">
                                <span class="metric-label">Memory Usage:</span>
                                <div class="progress-bar">
                                    <div class="progress-fill" style="width: <?= $serverHealth['memory_usage'] ?>%"></div>
                                </div>
                                <span class="metric-value"><?= $serverHealth['memory_usage'] ?>%</span>
                            </div>
                            
                            <div class="metric">
                                <span class="metric-label">Disk Usage:</span>
                                <div class="progress-bar">
                                    <div class="progress-fill" style="width: <?= $serverHealth['disk_usage'] ?>%"></div>
                                </div>
                                <span class="metric-value"><?= $serverHealth['disk_usage'] ?>%</span>
                            </div>
                            
                            <div class="metric">
                                <span class="metric-label">Weaviate Status:</span>
                                <span class="status-indicator <?= $serverHealth['weaviate_status'] ?>">
                                    <?= ucfirst($serverHealth['weaviate_status']) ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Pipeline Status -->
                <div class="card">
                    <div class="card-header">
                        <h2>Data Pipeline Status</h2>
                        <button class="btn btn-sm btn-primary" onclick="refreshPipeline()">Refresh</button>
                    </div>
                    <div class="card-body">
                        <div class="pipeline-status">
                            <div class="pipeline-item">
                                <span class="pipeline-label">Last Data Fetch:</span>
                                <span><?= $pipelineStatus['last_fetch'] ?></span>
                            </div>
                            <div class="pipeline-item">
                                <span class="pipeline-label">Records Processed Today:</span>
                                <span><?= number_format($pipelineStatus['processed_today']) ?></span>
                            </div>
                            <div class="pipeline-item">
                                <span class="pipeline-label">Articles Generated Today:</span>
                                <span><?= number_format($pipelineStatus['articles_today']) ?></span>
                            </div>
                            <div class="pipeline-item">
                                <span class="pipeline-label">Next Scheduled Run:</span>
                                <span><?= $pipelineStatus['next_run'] ?></span>
                            </div>
                            <div class="pipeline-item">
                                <span class="pipeline-label">Pipeline Status:</span>
                                <span class="status-indicator <?= $pipelineStatus['status'] ?>">
                                    <?= ucfirst($pipelineStatus['status']) ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="grid-2">
                    <!-- Recent Articles -->
                    <div class="card">
                        <div class="card-header">
                            <h2>Recent Articles</h2>
                            <a href="/admin/articles.php" class="btn-link">View All →</a>
                        </div>
                        <div class="card-body">
                            <div class="article-list">
                                <?php foreach ($recentArticles as $article): ?>
                                <div class="article-item">
                                    <div class="article-info">
                                        <a href="/admin/edit-article.php?id=<?= $article['id'] ?>" class="article-title">
                                            <?= htmlspecialchars($article['title']) ?>
                                        </a>
                                        <div class="article-meta">
                                            <?= $article['published_date'] ?> • <?= $article['views'] ?> views
                                        </div>
                                    </div>
                                    <div class="article-actions">
                                        <a href="/<?= $article['slug'] ?>" target="_blank" class="btn-icon" title="View">👁️</a>
                                        <a href="/admin/edit-article.php?id=<?= $article['id'] ?>" class="btn-icon" title="Edit">✏️</a>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Popular Articles -->
                    <div class="card">
                        <div class="card-header">
                            <h2>Popular Articles</h2>
                            <a href="/admin/analytics.php" class="btn-link">View Analytics →</a>
                        </div>
                        <div class="card-body">
                            <div class="article-list">
                                <?php foreach ($popularArticles as $article): ?>
                                <div class="article-item">
                                    <div class="article-info">
                                        <a href="/admin/edit-article.php?id=<?= $article['id'] ?>" class="article-title">
                                            <?= htmlspecialchars($article['title']) ?>
                                        </a>
                                        <div class="article-meta">
                                            <?= number_format($article['views']) ?> views • <?= $article['avg_time'] ?>s avg
                                        </div>
                                    </div>
                                    <div class="article-actions">
                                        <a href="/<?= $article['slug'] ?>" target="_blank" class="btn-icon" title="View">👁️</a>
                                        <a href="/admin/edit-article.php?id=<?= $article['id'] ?>" class="btn-icon" title="Edit">✏️</a>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Analytics Chart -->
                <div class="card">
                    <div class="card-header">
                        <h2>Page Views (Last 7 Days)</h2>
                    </div>
                    <div class="card-body">
                        <canvas id="viewsChart" height="80"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Views Chart
        const ctx = document.getElementById('viewsChart').getContext('2d');
        const viewsChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: <?= json_encode($stats['chart_labels']) ?>,
                datasets: [{
                    label: 'Page Views',
                    data: <?= json_encode($stats['chart_data']) ?>,
                    borderColor: '#667eea',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    tension: 0.3
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
        
        function refreshPipeline() {
            location.reload();
        }
    </script>
</body>
</html>