<?php
session_start();

// Simple authentication
$valid_username = 'chris';
$valid_password = 'coffee123';

// Check if user is logging in
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($_POST['username'] === $valid_username && $_POST['password'] === $valid_password) {
        $_SESSION['authenticated'] = true;
    } else {
        $error = "Invalid credentials";
    }
}

// Check if user is logged out
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: database.php');
    exit;
}

// If not authenticated, show login form
if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - CleanKitchens Database Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: #2c3e50;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        .login-card {
            background: white;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
            width: 100%;
            max-width: 400px;
        }
        .login-title {
            color: #2c3e50;
            margin-bottom: 30px;
            text-align: center;
        }
        .btn-login {
            background: #3498db;
            border: none;
            padding: 12px;
            font-size: 16px;
        }
        .btn-login:hover {
            background: #2980b9;
        }
        .error-message {
            background: #f8d7da;
            color: #721c24;
            padding: 12px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="login-card">
        <h2 class="login-title">Database Admin Login</h2>
        <?php if (isset($error)): ?>
            <div class="error-message"><?php echo $error; ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="mb-3">
                <label for="username" class="form-label">Username</label>
                <input type="text" class="form-control" id="username" name="username" required autofocus>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" class="form-control" id="password" name="password" required>
            </div>
            <button type="submit" class="btn btn-primary btn-login w-100">Login</button>
        </form>
    </div>
</body>
</html>
<?php
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CleanKitchens Database Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; }
        .sidebar {
            min-height: 100vh;
            background: #2c3e50;
            color: white;
            padding: 20px 0;
        }
        .sidebar h3 { 
            padding: 0 20px;
            margin-bottom: 30px;
            color: #3498db;
        }
        .collection-item {
            padding: 10px 20px;
            cursor: pointer;
            transition: background 0.3s;
        }
        .collection-item:hover {
            background: #34495e;
        }
        .collection-item.active {
            background: #3498db;
            font-weight: bold;
        }
        .main-content {
            padding: 20px;
            overflow-x: auto;
        }
        .stats-card {
            background: white;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .field-badge {
            display: inline-block;
            padding: 2px 8px;
            margin: 2px;
            border-radius: 4px;
            font-size: 12px;
            background: #e9ecef;
        }
        .field-badge.filled { background: #d4edda; }
        .field-badge.empty { background: #f8d7da; }
        .truncate {
            max-width: 200px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        /* Force horizontal scrolling for wide tables */
        .dataTables_wrapper {
            overflow-x: auto !important;
            position: relative;
        }
        /* Sticky horizontal scroll bar at bottom */
        .dataTables_scrollBody::-webkit-scrollbar {
            height: 12px;
        }
        .dataTables_scrollBody::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 6px;
        }
        .dataTables_scrollBody::-webkit-scrollbar-thumb {
            background: #888;
            border-radius: 6px;
        }
        .dataTables_scrollBody::-webkit-scrollbar-thumb:hover {
            background: #555;
        }
        /* Keep scroll bar visible and sticky */
        .dataTables_scrollBody {
            padding-bottom: 15px;
        }
        .status-badge {
            padding: 3px 10px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: bold;
        }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-processing { background: #cce5ff; color: #004085; }
        .status-processed { background: #d1ecf1; color: #0c5460; }
        .status-completed { background: #d4edda; color: #155724; }
        .status-error { background: #f8d7da; color: #721c24; }
        #recordModal .modal-body {
            max-height: 70vh;
            overflow-y: auto;
        }
        .json-display {
            background: #f4f4f4;
            padding: 10px;
            border-radius: 4px;
            font-family: monospace;
            font-size: 12px;
            white-space: pre-wrap;
        }
        .filter-section {
            background: white;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .loading-overlay.show { display: flex; }
    </style>
</head>
<body>
    <div class="loading-overlay" id="loadingOverlay">
        <div class="spinner-border text-light" style="width: 3rem; height: 3rem;"></div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar">
                <h3><i class="fas fa-database"></i> DB Admin</h3>
                <div class="collection-list">
                    <div class="collection-item" onclick="loadCollection('ChicagoTemp')">
                        <i class="fas fa-table"></i> ChicagoTemp
                        <span class="badge bg-warning float-end" id="count-ChicagoTemp">0</span>
                    </div>
                    <div class="collection-item" onclick="loadCollection('Articles')">
                        <i class="fas fa-newspaper"></i> Articles
                        <span class="badge bg-success float-end" id="count-Articles">0</span>
                    </div>
                </div>
                
                <hr class="my-4" style="border-color: #7f8c8d;">
                
                <div class="px-3">
                    <h5 class="mb-3">Quick Actions</h5>
                    <button class="btn btn-sm btn-primary w-100 mb-2" onclick="refreshData()">
                        <i class="fas fa-sync"></i> Refresh
                    </button>
                    <button class="btn btn-sm btn-info w-100 mb-2" onclick="exportData()">
                        <i class="fas fa-download"></i> Export CSV
                    </button>
                    <hr class="my-3" style="border-color: #7f8c8d;">
                    <a href="?logout=1" class="btn btn-sm btn-danger w-100">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-md-10 main-content">
                <h1 id="collectionTitle">Select a Collection</h1>
                
                <!-- Stats Cards -->
                <div class="row" id="statsSection" style="display: none;">
                    <div class="col-md-3">
                        <div class="stats-card">
                            <h6 class="text-muted">Total Records</h6>
                            <h3 id="totalRecords">0</h3>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="stats-card">
                            <h6 class="text-muted">Pending</h6>
                            <h3 class="text-warning" id="pendingCount">0</h3>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="stats-card">
                            <h6 class="text-muted">Processed</h6>
                            <h3 class="text-info" id="processedCount">0</h3>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="stats-card">
                            <h6 class="text-muted">Completed</h6>
                            <h3 class="text-success" id="completedCount">0</h3>
                        </div>
                    </div>
                </div>

                <!-- Filters -->
                <div class="filter-section" id="filterSection" style="display: none;">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Status Filter:</label>
                            <select class="form-select" id="statusFilter" onchange="applyFilters()">
                                <option value="">All</option>
                                <option value="pending">Pending</option>
                                <option value="processing">Processing</option>
                                <option value="processed">Processed</option>
                                <option value="completed">Completed</option>
                                <option value="error">Error</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Search Facility:</label>
                            <input type="text" class="form-control" id="facilitySearch" placeholder="Enter name..." onkeyup="applyFilters()">
                        </div>
                        <div class="col-md-3">
                            <label>Date Range:</label>
                            <input type="date" class="form-control" id="dateFilter" onchange="applyFilters()">
                        </div>
                        <div class="col-md-3">
                            <label>&nbsp;</label>
                            <button class="btn btn-secondary w-100" onclick="clearFilters()">
                                <i class="fas fa-times"></i> Clear Filters
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Data Table -->
                <div class="table-responsive" id="tableSection" style="display: none;">
                    <table id="dataTable" class="table table-striped table-bordered" style="width: 100%;">
                        <thead>
                            <tr id="tableHeaders"></tr>
                        </thead>
                        <tbody id="tableBody"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Record Detail Modal -->
    <div class="modal fade" id="recordModal" tabindex="-1">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Record Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="recordDetails"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" onclick="editRecord()">Edit</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script>
        let currentCollection = null;
        let currentData = [];
        let dataTable = null;
        let currentRecord = null;

        // Initialize
        $(document).ready(function() {
            updateCollectionCounts();
        });

        function showLoading() {
            document.getElementById('loadingOverlay').classList.add('show');
        }

        function hideLoading() {
            document.getElementById('loadingOverlay').classList.remove('show');
        }

        function updateCollectionCounts() {
            fetch('database_api.php?action=counts')
                .then(response => response.json())
                .then(data => {
                    if (data.ChicagoTemp) {
                        document.getElementById('count-ChicagoTemp').textContent = data.ChicagoTemp.toLocaleString();
                    }
                    if (data.Articles) {
                        document.getElementById('count-Articles').textContent = data.Articles.toLocaleString();
                    }
                })
                .catch(error => console.error('Error fetching counts:', error));
        }

        function loadCollection(collectionName) {
            showLoading();
            currentCollection = collectionName;
            
            // Update UI
            document.querySelectorAll('.collection-item').forEach(item => {
                item.classList.remove('active');
            });
            event.target.closest('.collection-item').classList.add('active');
            
            document.getElementById('collectionTitle').textContent = collectionName + ' Collection';
            document.getElementById('statsSection').style.display = 'flex';
            document.getElementById('filterSection').style.display = 'block';
            document.getElementById('tableSection').style.display = 'block';
            
            // Fetch data
            fetch(`database_api.php?action=list&collection=${collectionName}&limit=100`)
                .then(response => response.json())
                .then(data => {
                    currentData = data.records || [];
                    updateStats(data.stats);
                    displayData(currentData);
                    hideLoading();
                })
                .catch(error => {
                    console.error('Error loading collection:', error);
                    hideLoading();
                    alert('Error loading collection data');
                });
        }

        function updateStats(stats) {
            if (!stats) return;
            
            document.getElementById('totalRecords').textContent = (stats.total || 0).toLocaleString();
            document.getElementById('pendingCount').textContent = (stats.pending || 0).toLocaleString();
            document.getElementById('processedCount').textContent = (stats.processed || 0).toLocaleString();
            document.getElementById('completedCount').textContent = (stats.completed || 0).toLocaleString();
        }

        function displayData(records) {
            if (!records || records.length === 0) {
                document.getElementById('tableHeaders').innerHTML = '<th>No Data</th>';
                document.getElementById('tableBody').innerHTML = '<tr><td>No records found</td></tr>';
                return;
            }
            
            // Get all unique fields from records
            const fields = new Set();
            records.forEach(record => {
                Object.keys(record).forEach(key => fields.add(key));
            });
            
            // Priority fields to show first - show ALL fields for full view
            const priorityFields = ['id', 'facility_name', 'inspection_date', 'status', 'results', 'violations', 
                                   'cuisine_type', 'neighborhood', 'violation_category', 'violation_severity',
                                   'is_chain', 'chain_name', 'price_range', 'service_style'];
            const sortedFields = [...priorityFields.filter(f => fields.has(f)), 
                                 ...Array.from(fields).filter(f => !priorityFields.includes(f))];
            
            // Build headers - show ALL fields, not just first 8
            let headers = '<th style="min-width: 80px;">Actions</th>';
            sortedFields.forEach(field => {
                headers += `<th style="min-width: 120px;">${field.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase())}</th>`;
            });
            document.getElementById('tableHeaders').innerHTML = headers;
            
            // Build rows
            let rows = '';
            records.forEach((record, index) => {
                rows += '<tr>';
                rows += `<td>
                    <button class="btn btn-sm btn-info" onclick="viewRecord(${index})">
                        <i class="fas fa-eye"></i>
                    </button>
                </td>`;
                
                sortedFields.forEach(field => {
                    let value = record[field];
                    let displayValue = '';
                    
                    if (field === 'status') {
                        displayValue = `<span class="status-badge status-${value}">${value || 'unknown'}</span>`;
                    } else if (value === null || value === undefined || value === '') {
                        displayValue = '<span class="text-muted">-</span>';
                    } else if (typeof value === 'object') {
                        displayValue = `<span class="badge bg-secondary">${Array.isArray(value) ? value.length + ' items' : 'object'}</span>`;
                    } else if (field === 'violations' && value.length > 100) {
                        displayValue = `<div class="truncate" title="${value.replace(/"/g, '&quot;')}">${value.substring(0, 100)}...</div>`;
                    } else {
                        displayValue = `<div class="truncate" title="${String(value).replace(/"/g, '&quot;')}">${value}</div>`;
                    }
                    
                    rows += `<td>${displayValue}</td>`;
                });
                rows += '</tr>';
            });
            
            document.getElementById('tableBody').innerHTML = rows;
            
            // Initialize or reinitialize DataTable
            if (dataTable) {
                dataTable.destroy();
            }
            
            dataTable = $('#dataTable').DataTable({
                pageLength: 25,
                order: [[1, 'desc']],
                scrollX: true,
                scrollCollapse: true,
                columnDefs: [
                    { orderable: false, targets: 0 }
                ],
                dom: 'Bfrtip',
                language: {
                    paginate: {
                        previous: '← Previous',
                        next: 'Next →'
                    }
                }
            });
        }

        function viewRecord(index) {
            currentRecord = currentData[index];
            if (!currentRecord) return;
            
            let html = '<div class="row">';
            
            // Group fields by category
            const categories = {
                'Core Data': ['facility_name', 'address', 'city', 'state', 'zip_code', 'inspection_date', 'results'],
                'Violations': ['violations', 'violation_count', 'violation_category', 'violation_severity', 'critical_violations'],
                'Metadata': ['cuisine_type', 'service_style', 'price_range', 'is_chain', 'chain_name', 'neighborhood'],
                'Processing': ['status', 'created_at', 'processed_at', 'claude_response', 'error_log'],
                'Content': ['title', 'slug', 'content', 'excerpt', 'meta_description', 'tags']
            };
            
            Object.entries(categories).forEach(([category, fields]) => {
                html += `<div class="col-md-6 mb-3">
                    <h6 class="border-bottom pb-2 mb-3">${category}</h6>`;
                
                fields.forEach(field => {
                    if (currentRecord.hasOwnProperty(field)) {
                        let value = currentRecord[field];
                        let displayValue = '';
                        
                        if (value === null || value === undefined || value === '') {
                            displayValue = '<span class="text-muted">Empty</span>';
                        } else if (typeof value === 'object') {
                            displayValue = `<div class="json-display">${JSON.stringify(value, null, 2)}</div>`;
                        } else if (field === 'violations' || field === 'content' || field === 'claude_response') {
                            displayValue = `<div class="json-display">${value}</div>`;
                        } else {
                            displayValue = value;
                        }
                        
                        html += `<div class="mb-2">
                            <strong>${field.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase())}:</strong><br>
                            ${displayValue}
                        </div>`;
                    }
                });
                
                html += '</div>';
            });
            
            html += '</div>';
            
            document.getElementById('recordDetails').innerHTML = html;
            new bootstrap.Modal(document.getElementById('recordModal')).show();
        }

        function applyFilters() {
            if (!currentData) return;
            
            const status = document.getElementById('statusFilter').value;
            const facility = document.getElementById('facilitySearch').value.toLowerCase();
            const date = document.getElementById('dateFilter').value;
            
            let filtered = currentData;
            
            if (status) {
                filtered = filtered.filter(r => r.status === status);
            }
            
            if (facility) {
                filtered = filtered.filter(r => 
                    r.facility_name && r.facility_name.toLowerCase().includes(facility)
                );
            }
            
            if (date) {
                filtered = filtered.filter(r => 
                    r.inspection_date && r.inspection_date.startsWith(date)
                );
            }
            
            displayData(filtered);
        }

        function clearFilters() {
            document.getElementById('statusFilter').value = '';
            document.getElementById('facilitySearch').value = '';
            document.getElementById('dateFilter').value = '';
            displayData(currentData);
        }

        function refreshData() {
            if (currentCollection) {
                loadCollection(currentCollection);
            }
            updateCollectionCounts();
        }

        function exportData() {
            if (!currentCollection) {
                alert('Please select a collection first');
                return;
            }
            
            window.location.href = `database_api.php?action=export&collection=${currentCollection}`;
        }

        function editRecord() {
            alert('Edit functionality coming soon');
        }
    </script>
</body>
</html>