@echo off
title Python System Diagnostic
color 0A

echo ============================================
echo   PYTHON SYSTEM DIAGNOSTIC
echo ============================================
echo.

echo [TEST 1] Checking Python Installation
echo --------------------------------------
python --version 2>nul
if %errorlevel% neq 0 (
    echo Python command not found, trying py...
    py --version 2>nul
    if %errorlevel% neq 0 (
        echo ERROR: Python not found in PATH
        echo.
        echo Checking common locations...
        if exist "%LOCALAPPDATA%\Programs\Python\Python312\python.exe" (
            echo Found at: %LOCALAPPDATA%\Programs\Python\Python312\
            set PYTHON_EXE=%LOCALAPPDATA%\Programs\Python\Python312\python.exe
        ) else if exist "%LOCALAPPDATA%\Programs\Python\Python311\python.exe" (
            echo Found at: %LOCALAPPDATA%\Programs\Python\Python311\
            set PYTHON_EXE=%LOCALAPPDATA%\Programs\Python\Python311\python.exe
        ) else if exist "C:\Python312\python.exe" (
            echo Found at: C:\Python312\
            set PYTHON_EXE=C:\Python312\python.exe
        ) else (
            echo Python installation not found!
            goto :end
        )
    ) else (
        echo Python found via 'py' command
        set PYTHON_EXE=py
    )
) else (
    echo Python found via 'python' command
    set PYTHON_EXE=python
)
echo.

echo [TEST 2] Checking pip
echo ----------------------
%PYTHON_EXE% -m pip --version
if %errorlevel% neq 0 (
    echo ERROR: pip not working
) else (
    echo pip is working
)
echo.

echo [TEST 3] Testing Python Execution
echo ----------------------------------
%PYTHON_EXE% -c "import sys; print(f'Python {sys.version}')"
echo.

echo [TEST 4] Checking Required Packages
echo ------------------------------------
echo Checking selenium...
%PYTHON_EXE% -c "import selenium; print(f'  selenium version: {selenium.__version__}')" 2>nul
if %errorlevel% neq 0 (
    echo   selenium: NOT INSTALLED
    set NEED_INSTALL=1
) else (
    echo   selenium: OK
)

echo Checking requests...
%PYTHON_EXE% -c "import requests; print(f'  requests version: {requests.__version__}')" 2>nul
if %errorlevel% neq 0 (
    echo   requests: NOT INSTALLED
    set NEED_INSTALL=1
) else (
    echo   requests: OK
)

echo Checking webdriver-manager...
%PYTHON_EXE% -c "import webdriver_manager; print('  webdriver-manager: OK')" 2>nul
if %errorlevel% neq 0 (
    echo   webdriver-manager: NOT INSTALLED
    set NEED_INSTALL=1
) else (
    echo   webdriver-manager: OK
)
echo.

echo [TEST 5] Checking Chrome Browser
echo ---------------------------------
where chrome >nul 2>&1
if %errorlevel% equ 0 (
    echo Google Chrome: FOUND
) else (
    where chromium >nul 2>&1
    if %errorlevel% equ 0 (
        echo Chromium: FOUND
    ) else (
        if exist "%ProgramFiles%\Google\Chrome\Application\chrome.exe" (
            echo Chrome found at: %ProgramFiles%\Google\Chrome\
        ) else if exist "%ProgramFiles(x86)%\Google\Chrome\Application\chrome.exe" (
            echo Chrome found at: %ProgramFiles(x86)%\Google\Chrome\
        ) else (
            echo WARNING: Chrome/Chromium not found in PATH
            echo Please make sure Chrome is installed
        )
    )
)
echo.

echo [TEST 6] Quick Selenium Test
echo -----------------------------
%PYTHON_EXE% -c "from selenium import webdriver; from selenium.webdriver.chrome.options import Options; print('Selenium can be imported successfully')" 2>nul
if %errorlevel% neq 0 (
    echo ERROR: Cannot import Selenium properly
) else (
    echo Selenium imports: OK
)
echo.

if defined NEED_INSTALL (
    echo ============================================
    echo   MISSING PACKAGES DETECTED
    echo ============================================
    echo.
    echo Would you like to install missing packages?
    echo Press Y to install, N to skip
    choice /C YN /N
    if errorlevel 2 goto :skip_install
    
    echo.
    echo Installing packages...
    %PYTHON_EXE% -m pip install selenium requests webdriver-manager
    echo.
    echo Installation complete!
)

:skip_install
echo.
echo ============================================
echo   DIAGNOSTIC COMPLETE
echo ============================================
echo.
echo Summary:
echo - Python: %PYTHON_EXE%
%PYTHON_EXE% -c "import sys; print(f'- Version: {sys.version.split()[0]}')"
echo.

echo Creating test script...
(
echo import time
echo print('This is a test Python script')
echo print('It will stay open for 5 seconds...')
echo for i in range(5, 0, -1):
echo     print(f'Closing in {i}...')
echo     time.sleep(1)
echo print('Test complete!')
) > test_python.py

echo.
echo Running test script to verify Python works...
echo ----------------------------------------------
%PYTHON_EXE% test_python.py
del test_python.py

:end
echo.
echo ============================================
echo Press any key to exit...
pause >nul