<?php

/**

 * Search Page Configuration

 * 

 * This file contains configuration and metadata for the search page.

 */



// Page metadata

$page_title = "Search Recovery Resources | SoberList";

$page_description = "Search our comprehensive database of sober living homes, treatment centers, detox facilities, and mental health resources nationwide.";

$page_image = "/assets/images/search-banner.webp";



// Page-specific flags

$show_search_form = true;

$show_featured_resources = false;

$is_homepage = false;

$include_directory_css = true; // Include directory CSS for result display



// Include maps for map view

if (isset($_GET['view']) && $_GET['view'] === 'map') {

    $include_maps = true;

    $google_maps_api_key = defined('GOOGLE_MAPS_API_KEY') ? GOOGLE_MAPS_API_KEY : '';

}



// Keywords for SEO

$keywords = "recovery resources, addiction treatment, sober living, detox facilities, mental health resources, treatment finder";



// Schema.org JSON-LD structured data

$schema = [

    "@context" => "https://schema.org",

    "@type" => "WebSite",

    "url" => "https://www.soberlist.org",

    "potentialAction" => [

        "@type" => "SearchAction",

        "target" => "https://www.soberlist.org/search?q={search_term_string}",

        "query-input" => "required name=search_term_string"

    ],

    "name" => "SoberList",

    "description" => "Search recovery resources including sober living homes, treatment centers, detox facilities, and mental health services nationwide."

];



// Convert to JSON for inclusion in header

$schema_json = json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);