<?php

/**

 * Contact Page Configuration

 * 

 * This file contains configuration and metadata for the contact page.

 */



// Page metadata

$page_title = "Contact SoberList - Get in Touch";

$page_description = "Have questions? Contact SoberList to learn more about our recovery resource directory and services.";

$page_image = "/assets/images/contact-banner.webp";



// Page-specific flags

$show_search_form = false;

$show_featured_resources = false;

$is_homepage = false;



// Schema.org JSON-LD structured data

$schema = [

    "@context" => "https://schema.org",

    "@type" => "Organization",

    "name" => "SoberList",

    "url" => "https://www.soberlist.org/contact",

    "logo" => "https://www.soberlist.org/assets/images/logo.png",

    "description" => "Contact SoberList for information about our recovery resource directory.",

    "contactPoint" => [

        "@type" => "ContactPoint",

        "telephone" => "+1-888-501-7071",

        "email" => "info@soberlist.org",

        "contactType" => "customer service"

    ],

    "sameAs" => [

        "https://www.facebook.com/soberlist",

        "https://www.twitter.com/soberlist",

        "https://www.instagram.com/soberlist"

    ]

];



// Convert to JSON for inclusion in header

$schema_json = json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);