<?php
/**
 * Terms of Service Page - CleanKitchens.org
 */

// Include header (which loads config.php)
include(BASE_PATH . '/app/Views/components/header.php');
?>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 col-md-10 mx-auto">
            <h1 class="text-center mb-4">Terms of Service</h1>
            
            <p class="lead text-center mb-5">
                Effective Date: <?php echo date('F j, Y'); ?>
            </p>
            
            <div class="alert alert-info mb-5">
                <p class="mb-0">
                    <i class="bi bi-info-circle me-2"></i> By accessing or using CleanKitchens.org, you agree to be bound by these Terms of Service. Please read them carefully.
                </p>
            </div>
            
            <h2 class="mb-3">1. Acceptance of Terms</h2>
            <p>
                By accessing or using CleanKitchens.org ("the Service"), you agree to be bound by these Terms of Service. If you do not agree to all the terms and conditions, you must not access or use the Service.
            </p>
            
            <h2 class="mt-5 mb-3">2. Information Disclaimer</h2>
            <p>
                CleanKitchens.org provides information sourced from public health inspection records. While we strive for accuracy:
            </p>
            <ul>
                <li>All content is provided "as is" without warranty of any kind</li>
                <li>We do not guarantee the completeness, accuracy, or timeliness of information</li>
                <li>Health inspection data is sourced from government agencies and may contain errors or be outdated</li>
                <li>We are not responsible for decisions made based on this information</li>
            </ul>
            
            <h2 class="mt-5 mb-3">3. No Professional Advice</h2>
            <p>
                The information provided on CleanKitchens.org is for general informational purposes only. It does not constitute legal, medical, or professional advice. Always consult qualified professionals for specific advice related to your situation.
            </p>
            
            <h2 class="mt-5 mb-3">4. User Conduct</h2>
            <p>
                When using CleanKitchens.org, you agree not to:
            </p>
            <ul>
                <li>Violate any applicable laws or regulations</li>
                <li>Infringe on the rights of others</li>
                <li>Interfere with the operation of the Service</li>
                <li>Use the Service for unauthorized commercial purposes</li>
                <li>Attempt to gain unauthorized access to any part of the Service</li>
                <li>Use automated means to access or collect data from the Service</li>
            </ul>
            
            <h2 class="mt-5 mb-3">5. Intellectual Property</h2>
            <p>
                All content, features, and functionality on CleanKitchens.org, including text, graphics, logos, icons, and images, are owned by CleanKitchens.org or its licensors and protected by copyright, trademark, and other intellectual property laws.
            </p>
            
            <h2 class="mt-5 mb-3">6. Third-Party Links</h2>
            <p>
                CleanKitchens.org may contain links to third-party websites. These links are provided for your convenience only. We have no control over and assume no responsibility for the content, privacy policies, or practices of any third-party websites.
            </p>
            
            <h2 class="mt-5 mb-3">7. Limitation of Liability</h2>
            <p>
                To the maximum extent permitted by law, CleanKitchens.org shall not be liable for any indirect, incidental, special, consequential, or punitive damages arising out of or related to your use of the Service.
            </p>
            
            <h2 class="mt-5 mb-3">8. Indemnification</h2>
            <p>
                You agree to indemnify and hold harmless CleanKitchens.org and its officers, directors, employees, and agents from any claims, damages, losses, liabilities, costs, and expenses arising from your use of the Service or violation of these Terms.
            </p>
            
            <h2 class="mt-5 mb-3">9. Modifications</h2>
            <p>
                We reserve the right to modify these Terms at any time. Changes will be effective upon posting to the website. Your continued use of the Service after any changes indicates your acceptance of the modified Terms.
            </p>
            
            <h2 class="mt-5 mb-3">10. Governing Law</h2>
            <p>
                These Terms shall be governed by and construed in accordance with the laws of the State of New Hampshire, without regard to its conflict of law provisions.
            </p>
            
            <h2 class="mt-5 mb-3">11. Contact Information</h2>
            <p>
                For questions about these Terms, please contact us at:
            </p>
            <p>
                <i class="bi bi-envelope me-2"></i>terms@cleankitchens.org
            </p>
        </div>
    </div>
</div>

<?php
// Include footer
include(BASE_PATH . '/app/Views/components/footer.php');
?>