<?php

/**

 * Home Page Configuration

 * 

 * This file contains configuration and metadata for the home page.

 */



// Page metadata

$page_title = "SoberList - Find Recovery Resources Near You";

$page_description = "Find verified sober living homes, detox facilities, treatment centers, and mental health resources nationwide. SoberList connects individuals with recovery support.";

$page_image = "/assets/images/home-banner.webp";



// Page-specific flags

$show_search_form = true;

$show_featured_resources = true;

$is_homepage = true;



// Schema.org JSON-LD structured data

$schema = [

    "@context" => "https://schema.org",

    "@type" => "Organization",

    "name" => "SoberList",

    "url" => "https://www.soberlist.org",

    "logo" => "https://www.soberlist.org/assets/images/logo.png",

    "description" => "SoberList is America's largest directory of recovery resources including sober living homes, treatment centers, and mental health services.",

    "contactPoint" => [

        "@type" => "ContactPoint",

        "telephone" => "+1-555-123-4567",

        "contactType" => "customer service"

    ],

    "sameAs" => [

        "https://www.facebook.com/soberlist",

        "https://www.twitter.com/soberlist",

        "https://www.instagram.com/soberlist"

    ]

];



// Convert to JSON for inclusion in header

$schema_json = json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);