<?php
/**
 * Data Sources Page - CleanKitchens.org
 */

// Include header (which loads config.php)
include(BASE_PATH . '/app/Views/components/header.php');
?>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 col-md-10 mx-auto">
            <h1 class="text-center mb-4">Our Data Sources</h1>
            
            <p class="lead text-center mb-5">
                Transparency is core to our mission. Learn exactly where our health inspection data comes from.
            </p>
            
            <div class="alert alert-info mb-5">
                <p class="mb-0">
                    <i class="bi bi-info-circle me-2"></i> All restaurant inspection data on CleanKitchens.org is sourced directly from official government health departments. We never alter inspection results or scores.
                </p>
            </div>
            
            <!-- Data Collection Process -->
            <h2 class="mt-5 mb-3">How We Collect Data</h2>
            <p>
                CleanKitchens.org collects restaurant health inspection data through several official channels:
            </p>
            <ol>
                <li><strong>Public Records APIs:</strong> Many health departments now offer API (Application Programming Interface) access to their inspection data. We connect directly to these APIs to import the most current information.</li>
                <li><strong>Open Data Portals:</strong> We access state and municipal open data portals that publish inspection results in machine-readable formats.</li>
                <li><strong>Freedom of Information Act (FOIA) Requests:</strong> For jurisdictions without readily available digital access, we file formal requests for data under public records laws.</li>
                <li><strong>Direct Partnerships:</strong> In some cases, we work directly with health departments to establish data sharing protocols that benefit the public.</li>
            </ol>
            <p>Our data collection processes are automated wherever possible to ensure timely updates while minimizing human error.</p>
            
            <!-- Covered Jurisdictions -->
            <h2 class="mt-5 mb-3">Currently Covered Jurisdictions</h2>
            <p>We currently provide health inspection data for the following states and jurisdictions:</p>
            
            
                
                <!-- Additional jurisdictions would be listed here -->
            </div>
            
            <p class="alert alert-primary">
                We're continuously expanding our coverage to include more states and municipalities. Check back regularly for updates.
            </p>
            
            <!-- Data Update Schedule -->
            <h2 class="mt-5 mb-3">Data Freshness & Update Schedule</h2>
            <p>
                We strive to provide the most current information available. Our update schedule varies by jurisdiction:
            </p>
            <ul>
                <li><strong>API-Connected Jurisdictions:</strong> Data typically updated within 24-48 hours of release</li>
                <li><strong>Open Data Portal Sources:</strong> Updated weekly</li>
                <li><strong>FOIA-Requested Data:</strong> Updated monthly or as new data becomes available</li>
            </ul>
            <p>
                Each restaurant listing displays a "Last Updated" timestamp to indicate data freshness.
            </p>
            
            <!-- Data Limitations -->
            <h2 class="mt-5 mb-3">Understanding Data Limitations</h2>
            <p>
                We're committed to transparency about limitations in our data:
            </p>
            <ul>
                <li><strong>Reporting Delays:</strong> There can be delays between when inspections occur and when the data is made public.</li>
                <li><strong>Jurisdictional Differences:</strong> Different health departments use different scoring systems, violation categories, and reporting methods.</li>
                <li><strong>Follow-up Inspections:</strong> Some jurisdictions may not immediately report follow-up inspections where violations were corrected.</li>
                <li><strong>Data Gaps:</strong> Occasional gaps may appear due to technical issues with source data.</li>
            </ul>
            <p>
                We make every effort to note these limitations within our restaurant listings when relevant.
            </p>
            
         
        </div>
    </div>
</div>

<?php
// Include footer
include(BASE_PATH . '/app/Views/components/footer.php');
?>