<?php

/**

 * About Page Configuration

 * 

 * This file contains configuration and metadata for the about page.

 */



// Page metadata

$page_title = "About SoberList - Our Mission and Values";

$page_description = "Learn about SoberList's mission to build the nation's most comprehensive and accessible recovery resource network.";

$page_image = "/assets/images/about-banner.webp";



// Page-specific flags

$show_search_form = false;

$show_featured_resources = false;

$is_homepage = false;



// Schema.org JSON-LD structured data

$schema = [

    "@context" => "https://schema.org",

    "@type" => "Organization",

    "name" => "SoberList",

    "url" => "https://www.soberlist.org/about",

    "logo" => "https://www.soberlist.org/assets/images/logo.png",

    "description" => "SoberList is building the nation's most comprehensive and accessible recovery resource network.",

    "contactPoint" => [

        "@type" => "ContactPoint",

        "telephone" => "+1-888-501-7071",

        "contactType" => "customer service"

    ],

    "sameAs" => [

        "https://www.facebook.com/soberlist",

        "https://www.twitter.com/soberlist",

        "https://www.instagram.com/soberlist"

    ]

];



// Convert to JSON for inclusion in header

$schema_json = json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);