@echo off
title San Francisco Inspection Collector
color 0A

echo ============================================================
echo   SAN FRANCISCO INSPECTION COLLECTOR
echo ============================================================
echo.

REM Check if Python is installed
python --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ERROR: Python is not installed or not in PATH
    echo.
    echo Please install Python from: https://www.python.org/downloads/
    echo Make sure to check "Add Python to PATH" during installation
    echo.
    pause
    exit /b 1
)

echo Found Python:
python --version
echo.

REM Install required packages if needed
echo Checking required packages...
pip show selenium >nul 2>&1
if %errorlevel% neq 0 (
    echo Installing Selenium...
    pip install selenium
)

pip show requests >nul 2>&1
if %errorlevel% neq 0 (
    echo Installing Requests...
    pip install requests
)

echo.
echo ============================================================
echo   IMPORTANT SETUP INSTRUCTIONS:
echo ============================================================
echo.
echo 1. Make sure Google Chrome is installed
echo.
echo 2. Download ChromeDriver from:
echo    https://chromedriver.chromium.org/downloads
echo    - Download the version matching your Chrome version
echo    - Extract chromedriver.exe to C:\Windows\ or this folder
echo.
echo 3. Edit SF_Collector_Windows.pyw to set:
echo    - SERVER_URL (your server address)
echo    - API_KEY (must match server)
echo    - COLLECT_LIMIT (number to collect)
echo.
echo ============================================================
echo.
echo Press any key to start collection...
pause >nul

REM Run the collector
python SF_Collector_Windows.pyw

echo.
echo Collection complete!
pause